IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_BLOQUEIO_COMPRA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_CPL_BLOQUEIO_COMPRA]
GO 

create PROCEDURE [dbo].[P_EST_PROD_CPL_BLOQUEIO_COMPRA](@CD_EMP			INT, 
															@CD_FILIAL			VARCHAR(2500),
															@DT_ENT				DATETIME, 
															@DT_VD_INI				DATETIME, 
															@DT_VD_FIM				DATETIME, 
															@CD_ARV_MERC_LINHA	VARCHAR(MAX) )
 	 
AS

	SET NOCOUNT ON; 
	
	
	 SELECT
		CD_EMP,
		CD_FILIAL 
	 INTO #PRC_FILIAL  
	 FROM PRC_FILIAL
	 WHERE
		CD_EMP = @CD_EMP
		AND CD_FILIAL  IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL)) ; 
		 
	SELECT 
		CD_EMP,
		CD_ARV_MERC_LINHA,
		DS_ARV_MERC_LINHA
	INTO #EST_ARV_MERC_LINHA
	FROM EST_ARV_MERC_LINHA
	WHERE 
		CD_ARV_MERC_LINHA  IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_ARV_MERC_LINHA))  
		AND CD_EMP=@CD_EMP;
		 
	SELECT 
		E.CD_EMP,
		E.CD_FILIAL,
		MAX(E.DT_ENT) DT_ENT,
		E.CD_PROD
	INTO
		#ULT_DT_ENT
	FROM 
		V_EST_NF_ENT E
		INNER JOIN  #PRC_FILIAL F  ON  
		E.CD_EMP = F.CD_EMP AND
		E.CD_FILIAL = F.CD_FILIAL
	WHERE
		E.CD_EMP=@CD_EMP
		AND E.TP_MOV IN (0,3,10)
		AND E.TP_MOV_OP_TRANSA  =0 
	GROUP BY 	
		E.CD_EMP,
		E.CD_FILIAL,
		E.CD_PROD;
	
	DELETE FROM #ULT_DT_ENT
	WHERE
		DT_ENT  > @DT_ENT;
 
	SELECT
		V.CD_FILIAL,
		V.CD_PROD,
		SUM(V.QT_IT)  QTDE
	INTO #ULT_3_MES_VD
	FROM
		V_PDV_VD_IT V
		INNER JOIN  #PRC_FILIAL F  ON  
		V.CD_EMP = F.CD_EMP AND
		V.CD_FILIAL = F.CD_FILIAL
	WHERE
		V.CD_EMP=@CD_EMP
		AND V.DT_VD BETWEEN  @DT_VD_INI AND @DT_VD_FIM
	GROUP BY 
		V.CD_FILIAL,
		V.CD_PROD;
	
	SELECT  
		C.CD_FILIAL,
		A.CD_PROD,
		A.DS_PROD,
		A.DS_ARV_MERC_LINHA,
		A.NM_FABRIC,
		S.DS_SIGLA,
		C.MEDIAF,
		CONVERT(MONEY, ROUND(((C.MEDIAF/30.000) * EMAX)	,0)) EMAX,
		CONVERT(MONEY, ROUND(((C.MEDIAF/30.000) * ESEG)	,0)) ESEG,
		C.QT_EST,
		ISNULL(T.VLR_TABELA,0) VLR_PMC,  
		E.DT_ENT,
		ISNULL(V.QTDE ,0) QTDE_VD
		INTO #RS_FINAL
	FROM 
		EST_PROD_CPL C
	
		INNER JOIN  #PRC_FILIAL F  ON  
		C.CD_EMP = F.CD_EMP AND
		C.CD_FILIAL = F.CD_FILIAL
			
		LEFT JOIN  EST_PROD_PRECO T    ON  
		C.CD_EMP = T.CD_EMP AND
		C.CD_PROD = T.CD_PROD  AND
		C.CD_FILIAL = T.CD_FILIAL  
		
		INNER JOIN  V_EST_PROD_ARV_MERCADOLOGICA A  ON  
		C.CD_EMP = A.CD_EMP AND
		C.CD_PROD = A.CD_PROD
		
		INNER JOIN #EST_ARV_MERC_LINHA L ON 
		A.CD_EMP = L.CD_EMP AND
		A.CD_ARV_MERC_LINHA= L.CD_ARV_MERC_LINHA
		 
		INNER JOIN  EST_PROD_CURVA_SIGLA S  ON  
		C.CD_EMP   = S.CD_EMP AND
		C.CD_SIGLA  = S.CD_SIGLA
		
		INNER JOIN  #ULT_DT_ENT E ON  
		C.CD_FILIAL = E.CD_FILIAL AND
		C.CD_PROD = E.CD_PROD
		
		LEFT JOIN #ULT_3_MES_VD V ON 
		C.CD_FILIAL = V.CD_FILIAL AND
		C.CD_PROD	= V.CD_PROD
	WHERE	
		C.CD_EMP=1
		AND C.QT_EST > 0
		AND C.STS_PROD = 0
		 
		DELETE FROM  #RS_FINAL
		WHERE QTDE_VD > 0
		
		SELECT  
			CD_FILIAL,
			CD_PROD,
			DS_PROD,
			DS_ARV_MERC_LINHA,
			NM_FABRIC,
			DS_SIGLA,
			MEDIAF,
			EMAX,
			ESEG,
			QT_EST,
			VLR_PMC,  
			DT_ENT
		FROM #RS_FINAL
		ORDER BY 
			CD_FILIAL, 
			CD_PROD 
		